### 配置参数定义

| **参数名称** | **描述** | **取值范围** | **说明** |
|---|---|---|---|
| Communication Mode | 通讯模式 | 0 | NoSelect即无选择 |
| 1 | Modbus RTU Master 即RTU主站模式 |
| 2 | Modbus RTU Slave 即RTU从站模式 |
| 3 | Modbus ASCII Master 即ASCII主站模式 |
| 4 | Modbus ASCII Slave 即ASCII从站模式 |
| 5 | FP\_Request 即自由口请求模式 |
| 6 | FP\_Input\_Output 即自由口输入输出模式 |
| 7 | FP\_Input 即自由口输入模式 |
| 8 | FP\_Output即自由口输出模式 |
| Baud Rate | 串行端口波特率 | 0 | 1200 bps |
| 1 | 2400 bps |
| 2 | 4800 bps |
| 3 | 9600 bps |
| 4 | 19200 bps |
| 5 | 38400 bps |
| 6 | 57600 bps |
| 7 | 115200 bps |
| Stop Bit | 停止位 | 0 | 1 Bit |
| 1 | 2 Bits |
| Word Format | 字符格式 | 0 | 8 Bits |
| 1 | 7 Bits |
| Parity | 奇偶校验位 | 0 | Parity None无校验 |
| 1 | Parity Odd奇校验 |
| 2 | Parity Even偶校验 |
| Control Mode | 控制与状态模式 | 0 | Disable 即控制与状态失能 |
| 1 | Level即控制与状态使能-高电平触发 |
| 2 | Rising Edge 即控制与状态使能-上升沿触发 |
| Node Output Mode | 节点输出模式 | 0 | Poll即轮询 |
| 1 | Change Trigger即逢变 |
| Communication Error Behavior | 通讯错误行为 | 0 | Clear即清空 |
| 1 | Hold即保持 |
| Respond Timeout | 响应时间 | 5~3000 | 单位ms，默认50 |
| Poll Delay | 轮询延时 | 5~3000 | 单位ms，默认10 |
| Slave ID | Modbus从站站号 | 1~247 | 在从站模式下有效，默认1 |
| Slave Respond Delay | 从站响应延时 | 0~3000 | 单位ms，默认10 |
| Node\_1\_Param\_01 | 节点1参数1 | 0~FFFFFFFF | 默认0 |
| Node\_1\_Param\_02 | 节点1参数2 | 0~FFFFFFFF | 默认0 |
| … | … | … | … |
| Node\_16\_Param\_01 | 节点16参数1 | 0~FFFFFFFF | 默认0 |
| Node\_16\_Param\_02 | 节点16参数2 | 0~FFFFFFFF | 默认0 |

---

### Modbus主站功能

Modbus主站模式下，参数1（Param\_01）是2字节的起始地址参数和2字节的节点代码参数构成，参数2（Param\_02）由2位的字节交换参数和1字节的从站站号参数构成。

| **Param\_01** |
|---|
| BIT31~BIT16 | BIT15~BIT0 |
| 起始地址Start Address | 节点代码Node Code 详见下表 |
| **Param\_02** |
| BIT31~BIT16 | BIT15~BIT10 | BIT9~BIT8 | BIT7~BIT0 |
| Reserve | 见下表ExByte Flag | 从站站号 Slave Station Number |

注：起始地址参数范围为0000~FFFFH，从站站号参数范围为1~247。

---

### Modbus主站功能节点代码

| **SubModule分组** | **SubModule** | **SubModule ID** |
|---|---|---|
| Modbus Master Read Coils即Modbus主站读取线圈 | Read 8 bits | 0x0101 |
| Read 16 bits | 0x0102 |
| Read 24 bits | 0x0103 |
| Read 32 bits | 0x0104 |
| Read 40 bits | 0x0105 |
| Read 48 bits | 0x0106 |
| Read 56 bits | 0x0107 |
| Read 64 bits | 0x0108 |
| Read 72 bits | 0x0109 |
| Read 80 bits | 0x010A |
| Read 88 bits | 0x010B |
| Read 96 bits | 0x010C |
| Read 104 bits | 0x010D |
| Read 112 bits | 0x010E |
| Read 120 bits | 0x010F |
| Read 128 bits | 0x0110 |
| Modbus Master Read Discrete即Modbus主站读取离散输入 | Read 8 bits | 0x0201 |
| Read 16 bits | 0x0202 |
| Read 24 bits | 0x0203 |
| Read 32 bits | 0x0204 |
| Read 40 bits | 0x0205 |
| Read 48 bits | 0x0206 |
| Read 56 bits | 0x0207 |
| Read 64 bits | 0x0208 |
| Read 72 bits | 0x0209 |
| Read 80 bits | 0x020A |
| Read 88 bits | 0x020B |
| Read 96 bits | 0x020C |
| Read 104 bits | 0x020D |
| Read 112 bits | 0x020E |
| Read 120 bits | 0x020F |
| Read 128 bits | 0x0210 |
| Modbus Master Read Hold即Modbus主站读保持寄存器 | Read 1 Reg | 0x0301 |
| Read 2 Regs | 0x0302 |
| Read 3 Regs | 0x0303 |
| Read 4 Regs | 0x0304 |
| Read 5 Regs | 0x0305 |
| Read 6 Regs | 0x0306 |
| Read 7 Regs | 0x0307 |
| Read 8 Regs | 0x0308 |
| Read 9 Regs | 0x0309 |
| Read 10 Regs | 0x030A |
| Read 11 Regs | 0x030B |
| Read 12 Regs | 0x030C |
| Read 13 Regs | 0x030D |
| Read 14 Regs | 0x030E |
| Read 15 Regs | 0x030F |
| Read 16 Regs | 0x0310 |
| Modbus Master Read Input即Modbus主站读输入寄存器 | Read 1 Reg | 0x0401 |
| Read 2 Regs | 0x0402 |
| Read 3 Regs | 0x0403 |
| Read 4 Regs | 0x0404 |
| Read 5 Regs | 0x0405 |
| Read 6 Regs | 0x0406 |
| Read 7 Regs | 0x0407 |
| Read 8 Regs | 0x0408 |
| Read 9 Regs | 0x0409 |
| Read 10 Regs | 0x040A |
| Read 11 Regs | 0x040B |
| Read 12 Regs | 0x040C |
| Read 13 Regs | 0x040D |
| Read 14 Regs | 0x040E |
| Read 15 Regs | 0x040F |
| Read 16 Regs | 0x0410 |
| Modbus Master Write Coils即Modbus主站写线圈 | Write 8 bits | 0x0501 |
| Write 16 bits | 0x0502 |
| Write 24 bits | 0x0503 |
| Write 32 bits | 0x0504 |
| Write 40 bits | 0x0505 |
| Write 48 bits | 0x0506 |
| Write 56 bits | 0x0507 |
| Write 64 bits | 0x0508 |
| Write 72 bits | 0x0509 |
| Write 80 bits | 0x050A |
| Write 88 bits | 0x050B |
| Write 96 bits | 0x050C |
| Write 104 bits | 0x050D |
| Write 112 bits | 0x050E |
| Write 120 bits | 0x050F |
| Write 128 bits | 0x0510 |
| Write Single bit | 0x05FF |
| Modbus Master Write Hold即Modbus主站写保持寄存器 | Write 1 Reg | 0x0601 |
| Write 2 Regs | 0x0602 |
| Write 3 Regs | 0x0603 |
| Write 4 Regs | 0x0604 |
| Write 5 Regs | 0x0605 |
| Write 6 Regs | 0x0606 |
| Write 7 Regs | 0x0607 |
| Write 8 Regs | 0x0608 |
| Write 9 Regs | 0x0609 |
| Write 10 Regs | 0x060A |
| Write 11 Regs | 0x060B |
| Write 12 Regs | 0x060C |
| Write 13 Regs | 0x060D |
| Write 14 Regs | 0x060E |
| Write 15 Regs | 0x060F |
| Write 16 Regs | 0x0610 |
| Write Single Reg | 0x06FF |

---

### Modbus 从站功能

Modbus从站模式下，参数1（Param\_01）是2字节的起始地址参数和2字节的节点代码参数构成，参数2（Param\_02）由2位的字节交换参数构成。

| **Param\_01** |
|---|
| BIT31~BIT16 | BIT15~BIT0 |
| 起始地址Start Address | 节点代码Node Code |
| **Param\_02** |
| BIT31~BIT16 | BIT15~BIT2 | BIT1~BIT0 |
| Reserve | ExByte Flag |

---

### Modbus从站功能节点代码

| **SubModule分组** | **SubModule** | **SubModule ID** |
|---|---|---|
| Modbus Slave Read Coils即Modbus从站读线圈 | Read 8 bits | 0x0701 |
| Read 16 bits | 0x0702 |
| Read 24 bits | 0x0703 |
| Read 32 bits | 0x0704 |
| Read 40 bits | 0x0705 |
| Read 48 bits | 0x0706 |
| Read 56 bits | 0x0707 |
| Read 64 bits | 0x0708 |
| Read 72 bits | 0x0709 |
| Read 80 bits | 0x070A |
| Read 88 bits | 0x070B |
| Read 96 bits | 0x070C |
| Read 104 bits | 0x070D |
| Read 112 bits | 0x070E |
| Read 120 bits | 0x070F |
| Read 128 bits | 0x0710 |
| Modbus Slave Read Hold即Modbus从站读保持寄存器 | Read 1 Reg | 0x0801 |
| Read 2 Regs | 0x0802 |
| Read 3 Regs | 0x0803 |
| Read 4 Regs | 0x0804 |
| Read 5 Regs | 0x0805 |
| Read 6 Regs | 0x0806 |
| Read 7 Regs | 0x0807 |
| Read 8 Regs | 0x0808 |
| Read 9 Regs | 0x0809 |
| Read 10 Regs | 0x080A |
| Read 11 Regs | 0x080B |
| Read 12 Regs | 0x080C |
| Read 13 Regs | 0x080D |
| Read 14 Regs | 0x080E |
| Read 15 Regs | 0x080F |
| Read 16 Regs | 0x0810 |
| Modbus Slave Write Coils即Modbus从站写线圈 | Write 8 bits | 0x0901 |
| Write 16 bits | 0x0902 |
| Write 24 bits | 0x0903 |
| Write 32 bits | 0x0904 |
| Write 40 bits | 0x0905 |
| Write 48 bits | 0x0906 |
| Write 56 bits | 0x0907 |
| Write 64 bits | 0x0908 |
| Write 72 bits | 0x0909 |
| Write 80 bits | 0x090A |
| Write 88 bits | 0x090B |
| Write 96 bits | 0x090C |
| Write 104 bits | 0x090D |
| Write 112 bits | 0x090E |
| Write 120 bits | 0x090F |
| Write 128 bits | 0x0910 |
| Modbus Slave Write Discrete即Modbus从站写离散输入 | Write 8 bits | 0x0A01 |
| Write 16 bits | 0x0A02 |
| Write 24 bits | 0x0A03 |
| Write 32 bits | 0x0A04 |
| Write 40 bits | 0x0A05 |
| Write 48 bits | 0x0A06 |
| Write 56 bits | 0x0A07 |
| Write 64 bits | 0x0A08 |
| Write 72 bits | 0x0A09 |
| Write 80 bits | 0x0A0A |
| Write 88 bits | 0x0A0B |
| Write 96 bits | 0x0A0C |
| Write 104 bits | 0x0A0D |
| Write 112 bits | 0x0A0E |
| Write 120 bits | 0x0A0F |
| Write 128 bits | 0x0A10 |
| Modbus Slave Write Hold即Modbus从站写保持寄存器 | Write 1 Reg | 0x0B01 |
| Write 2 Regs | 0x0B02 |
| Write 3 Regs | 0x0B03 |
| Write 4 Regs | 0x0B04 |
| Write 5 Regs | 0x0B05 |
| Write 6 Regs | 0x0B06 |
| Write 7 Regs | 0x0B07 |
| Write 8 Regs | 0x0B08 |
| Write 9 Regs | 0x0B09 |
| Write 10 Regs | 0x0B0A |
| Write 11 Regs | 0x0B0B |
| Write 12 Regs | 0x0B0C |
| Write 13 Regs | 0x0B0D |
| Write 14 Regs | 0x0B0E |
| Write 15 Regs | 0x0B0F |
| Write 16 Regs | 0x0B10 |
| Modbus Slave Write Input即Modbus从站写输入寄存器 | Write 1 Reg | 0x0C01 |
| Write 2 Regs | 0x0C02 |
| Write 3 Regs | 0x0C03 |
| Write 4 Regs | 0x0C04 |
| Write 5 Regs | 0x0C05 |
| Write 6 Regs | 0x0C06 |
| Write 7 Regs | 0x0C07 |
| Write 8 Regs | 0x0C08 |
| Write 9 Regs | 0x0C09 |
| Write 10 Regs | 0x0C0A |
| Write 11 Regs | 0x0C0B |
| Write 12 Regs | 0x0C0C |
| Write 13 Regs | 0x0C0D |
| Write 14 Regs | 0x0C0E |
| Write 15 Regs | 0x0C0F |
| Write 16 Regs | 0x0C10 |

---

### 字节交换

| **字节编号** | **功能** | **长度** |
|---|---|---|
| 0 | 不交换 | 2位Bits |
| 1 | 2Bytes Exchange | 2位Bits |
| 2 | 4Bytes Register Exchange | 2位Bits |
| 3 | 4Bytes Big-Little-Endian Exchange | 2位Bits |

---

### Freeport自由口功能

在Freeport自由口模式下，参数1（Param\_01）是2字节的节点代码参数构成。

| **Param\_01** |
|---|
| BIT31~BIT16 | BIT15~BIT0 |
| Reserve | 节点代码Node Code |
| **Param\_02** |
| BIT31~BIT0 |
| Reserve |

---

### Freeport功能节点代码

| **SubModule分组** | **SubModule** | **SubModule ID** |
|---|---|---|
| Freeport Input即自由口输入 | Input 1 byte | 0x0D01 |
| Input 2 bytes | 0x0D02 |
| Input 4 bytes | 0x0D03 |
| Input 8 bytes | 0x0D04 |
| Input 16 bytes | 0x0D05 |
| Input 32 bytes | 0x0D06 |
| Input 64 bytes | 0x0D07 |
| Input 128 bytes | 0x0D08 |
| Input 160 bytes | 0x0D09 |
| Input 192 bytes | 0x0D0A |
| Input 224 bytes | 0x0D0B |
| Input 255 bytes | 0x0D0C |
| Freeport Output即自由口输出 | Output 1 byte | 0x0E01 |
| Output 2 bytes | 0x0E02 |
| Output 4 bytes | 0x0E03 |
| Output 8 bytes | 0x0E04 |
| Output 16 bytes | 0x0E05 |
| Output 32 bytes | 0x0E06 |
| Output 64 bytes | 0x0E07 |
| Output 128 bytes | 0x0E08 |
| Output 160 bytes | 0x0E09 |
| Output 192 bytes | 0x0E0A |
| Output 224 bytes | 0x0E0B |
| Output 255 bytes | 0x0E0C |
| Freeport Parity即自由口奇偶校验 | CRC8 | 0x0F01 |
| CRC16 | 0x0F02 |
| XOR | 0x0F03 |
| SUM8 | 0x0F04 |
| LRC | 0x0F05 |

---

### 控制与状态节点代码

当配置参数Control Mode控制与状态模式设置为disable时，无需配置控制与状态节点代码；当配置参数Control Mode控制与状态模式设置为Level或Rising Edge时，必需先在节点1参数1（Node\_1\_Param\_01）配置节点代码。

节点代码如下表所示：

| **SubModule分组** | **SubModule** | **SubModule ID** | **备注** |
|---|---|---|---|
| Control&amp;Status | 1 Node | 0x0001 | 主站模式下配置 |
| 2 Node | 0x0002 |
| 3 Node | 0x0003 |
| 4 Node | 0x0004 |
| 5 Node | 0x0005 |
| 6 Node | 0x0006 |
| 7 Node | 0x0007 |
| 8 Node | 0x0008 |
| 9 Node | 0x0009 |
| 10 Node | 0x000A |
| 11 Node | 0x000B |
| 12 Node | 0x000C |
| 13 Node | 0x000D |
| 14 Node | 0x000E |
| 15 Node | 0x000F |
| Freeport Req | 0x0020 | 自由口模式下配置 |
| Freeport Input\_Output | 0x0021 |
| Freeport Input | 0x0022 |
| Freeport Output | 0x0023 |
| Modbus Slave | 0x0030 | 从站模式下配置 |

---



### 过程数据

模块出厂默认为SRC6041-C01SP-32Bytes，上下行数据长度各32Bytes，当模块的通讯节点参数配置所产生的PDO数据量达到一定范围时（上行数据量或下行数据量任一到达范围限制），耦合器模块会告警0x5002，此时重新上电后扫描模块，模块会自动切换至相应的PDO数据长度。

模块PDO长度范围与型号匹配表：

| **模块PDO长度范围与型号匹配表** |
|---|
| **模块型号** | **上行数据长度（Bytes）** | **下行数据长度（Bytes）** |
| SRC6041-32Bytes | 0~32 | 0~32 |
| SRC6041-64Bytes | 33~64 | 33~64 |
| SRC6041-128Bytes | 65~128 | 65~128 |
| SRC6041-255Bytes | 129~255 | 129~255 |

下面以型号SRC6041-32Bytes为例介绍配置参数

当配置参数Control Mode控制与状态模式设置为disable时，上下行过程数据如下表所示。

| **上行数据（32字节）** |
|---|
| **字节编号** | **功能** | **含义** | **地址范围** |
| 1 | 输入数据 | 串口通讯模块输入数据 | 32个字节 |
| 2 | 输入数据 |
| … | … |
| 32 | 输入数据 |
| **下行数据（32字节）** |
| **字节编号** | **功能** | **含义** | **地址范围** |
| 1 | 输出数据 | 串口通讯模块输出数据 | 32个字节 |
| 2 | 输出数据 |
| … | … |
| 32 | 输出数据 |

当配置参数Control Mode控制与状态模式设置为Level或Rising Edge时，上下行过程数据如下表所示。

---

### Modbus主站过程数据

| **上行数据（32字节）** |
|---|
| **字节编号** | **功能** | **含义** | **地址范围** |
| 1 | 状态字 | Bit0：空闲状态 | 1个字节 |
| Bit1：busy状态，即传输数据中 |
| Bit2：完成状态，即传输数据完成 |
| 2 | 告警码 |  | 1个字节 |
| 3 | 输入数据 | 串口通讯模块输入数据 | 后30个字节 |
| 4 | 输入数据 |
| … | … |
| 32 | 输入数据 |
| **下行数据（32字节）** |
| **字节编号** | **功能** | **含义** | **地址范围** |
| 1 | 控制字 | 当配置参数Control Mode为Level，置1发送数据 | 1个字节 |
|  |  | 当配置参数Control Mode为Rising Edge，0-&gt;1发送数据 |  |
| 2 | 输出数据 | 串口通讯模块输出数据 | 后31个字节 |
| 3 | 输出数据 |
| … | … |
| 32 | 输出数据 |

注：上述表格过程数据是Level或Rising Edge模式下配置1个节点，如配置两个节点，上行数据的字节编号1和2为节点1的状态位和告警码，字节编号3和4为节点2的状态位和告警码，剩余字节为数据位；下行数据的字节编号1为节点1的控制位，字节编号2为节点2的控制位，剩余字节为数据位，最多可配置15个节点。

---

### Modbus从站过程数据

| **上行数据（32字节）** |
|---|
| **字节编号** | **功能** | **含义** | **地址范围** |
| 1 | 状态字 | Bit0：空闲状态 | 1个字节 |
|  |  | Bit1：busy状态，即传输数据中 |  |
|  |  | Bit2：完成状态，即传输数据完成 |  |
| 2 | 告警码 |  | 1个字节 |
| 3 | 输入数据 | 串口通讯模块输入数据 | 后30个字节 |
| 4 | 输入数据 |
| … | … |
| 32 | 输入数据 |
| **下行数据（32字节）** |
| **字节编号** | **功能** | **含义** | **地址范围** |
| 1 | 控制字 | Bit0：告警码清除 | 1个字节 |
| 2 | 输出数据 | 串口通讯模块输出数据 | 后31个字节 |
| 3 | 输出数据 |
| … | … |
| 32 | 输出数据 |

---

### Freeport\_Request过程数据

| **上行数据（32字节）** |
|---|
| **字节编号** | **功能** | **含义** | **地址范围** |
| 1 | 状态字 | Bit0：空闲状态 | 1个字节 |
| Bit1：busy状态，即传输数据中 |
| Bit2：完成状态，即传输数据完成 |
| 2 | 告警码 | Bit0：接收数据长度错误 | 1个字节 |
| Bit1：校验错误 |
| Bit2：超时错误 |
| 3 | 接收数据长度 | 0~255 | 1个字节 |
| 4~5 | 接收异常计数 | 0~65535 | 2个字节 |
| 6~7 | 接收数据计数 | 0~65535 | 2个字节 |
| 8 | 输入数据 | 串口通讯模块输入数据 | 后25个字节 |
| 9 | 输入数据 |
| … | … |
| 32 | 输入数据 |
| **下行数据（32字节）** |
| **字节编号** | **功能** | **含义** | **地址范围** |
| 1 | 控制字 | Bit0：使能 | 1个字节 |
| Bit1：状态字清空 |
| Bit2：接收数据清空 |
| 2 | 发送数据长度 | 0~255 | 1个字节 |
| 3 | 计数清零 | Bit0：接收异常计数清零 | 1个字节 |
| Bit1：接收数据计数清零 |
| Bit2：接收数据长度清零 |
| 4 | 错误码清零 | Bit0：长度异常清除 | 1个字节 |
| Bit1：校验错误清除 |
| Bit2：超时错误清除 |
| 5 | 输出数据 | 串口通讯模块输出数据 | 后28个字节 |
| 6 | 输出数据 |
| … | … |
| 32 | 输出数据 |

---

### Freeport\_Input过程数据

| **上行数据（32字节）** |
|---|
| **字节编号** | **功能** | **含义** | **地址范围** |
| 1 | 告警码 | Bit0：接收数据长度错误 | 1个字节 |
| Bit1：校验错误 |
| 2 | 接收数据长度 | 0~255 | 1个字节 |
| 3~4 | 接收异常计数 | 0~65535 | 2个字节 |
| 5~6 | 接收数据计数 | 0~65535 | 2个字节 |
| 7 | 输入数据 | 串口通讯模块输入数据 | 后26个字节 |
| 8 | 输入数据 |
| … | … |
| 32 | 输入数据 |
| **下行数据（32字节）** |
| **字节编号** | **功能** | **含义** | **地址范围** |
| 1 | 控制字 | Bit0：使能 | 1个字节 |
| Bit1：状态字清空 |
| Bit2：接收数据清空 |
| 2 | 计数清零 | Bit0：接收异常计数清零 | 1个字节 |
| Bit1：接收数据计数清零 |
| Bit2：接收数据长度清零 |
| 3 | 错误码清零 | Bit0：接收长度错误清除 | 1个字节 |
| Bit1：校验错误清除 |
| 4 | 输出数据 | 串口通讯模块输出数据 | 后29个字节 |
| 5 | 输出数据 |
| … | … |
| 32 | 输出数据 |

---

### Freeport\_Output过程数据

| **下行数据（32字节）** |
|---|
| **字节编号** | **功能** | **含义** | **地址范围** |
| 1 | 控制字 | Bit0：使能 | 1个字节 |
| 2 | 发送数据长度 | 0~255 | 1个字节 |
| 3 | 输出数据 | 串口通讯模块输出数据 | 后30个字节 |
| 4 | 输出数据 |
| … | … |
| 32 | 输出数据 |

---

### Freeport\_Input\_Output过程数据

| **上行数据（32字节）** |
|---|
| **字节编号** | **功能** | **含义** | **地址范围** |
| 1 | 告警码 | Bit0：接收数据长度错误 | 1个字节 |
| Bit1：校验错误 |
| 2 | 接收数据长度 | 0~255 | 1个字节 |
| 3~4 | 接收异常计数 | 0~65535 | 2个字节 |
| 5~6 | 接收数据计数 | 0~65535 | 2个字节 |
| 7 | 输入数据 | 串口通讯模块输入数据 | 后26个字节 |
| 8 | 输入数据 |
| … | … |
| 32 | 输入数据 |
| **下行数据（32字节）** |
| **字节编号** | **功能** | **含义** | **地址范围** |
| 1 | 控制字 | Bit0：使能 | 1个字节 |
| Bit1：状态字清空 |
| Bit2：接收数据清空 |
| 2 | 发送数据长度 | 0~255 | 1个字节 |
| 3 | 计数清零 | Bit0：接收异常计数清零 | 1个字节 |
| Bit1：接收数据计数清零 |
| Bit2：接收数据长度清零 |
| 4 | 错误码清零 | Bit0：接收长度错误清除 | 1个字节 |
| Bit1：校验错误清除 |
| 5 | 输出数据 | 串口通讯模块输出数据 | 后28个字节 |
| 6 | 输出数据 |
| … | … |
| 32 | 输出数据 |

---



### Modbus告警码

| **故障码** | **注释** |
|---|---|
| 0x00 | 无错误 |
| 0x01 | 从设备地址错误 |
| 0x02 | 功能码错误 |
| 0x03 | CRC校验错误 |
| 0x04 | 响应字节数错误 |
| 0x05 | 线圈寄存器数据错误 |
| 0x06 | 保持寄存器数据错误 |
| 0x07 | 非法数据地址 |
| 0x08 | 从设备故障 |
| 0x09 | LRC校验错误 |
| 0x0C | 数据长度错误 |
| 0x0D | 数据转换错误 |
| 0x0E | ASCII帧错误 |
| 0x0F | 响应超时 |